<?php
/**
 * Template Name: About Us Page
 *
 * @package WordPress
 */
get_header();
if (has_post_thumbnail()){ 
$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large');
} 
?>
<div role="main" class="main">
<!-- header section  -->
<section class="page-header page-header-modern page-header-background page-header-background-md parallax overlay overlay-color-dark overlay-show overlay-op-5 mt-0" data-plugin-parallax data-plugin-options="{'speed': 1.2}" data-image-src="<?php echo $thumbnail[0];?>">
<div class="container">
	<div class="row mt-5">
		<div class="col-md-12 align-self-center p-static order-2 text-center">
		   <?php while(have_posts() ) : the_post(); the_content(); endwhile; wp_reset_query();?>
		</div>
		<div class="col-md-12 align-self-center order-1">
			<ul class="breadcrumb breadcrumb-light d-block text-center">
				<li><a href="<?php echo home_url();?>">Home</a></li>
				<li class="active">About Us</li>
			</ul>
		</div>
	</div>
</div>
</section>

                <!-- boxes  -->

				<div class="container py-5 container container-xl-custom">

					<div class="row pb-4 mt-2">
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
                                    <img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-01.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_1',get_the_ID()); ?></h4>
									<p><?php echo the_field('service_description_1',get_the_ID()); ?></p>
								</div>
							</div>
						</div>
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
									<img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-02.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_2',get_the_ID()); ?></h4>
									<p><?php echo the_field('service_description_2',get_the_ID()); ?></p>
								</div>
							</div>
						</div>
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
									<img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-03.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_3',get_the_ID()); ?></h4>
								</div>
							</div>
						</div>
					</div>
					<div class="row pb-4">
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="800">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
									<img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-04.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_4',get_the_ID()); ?> </h4>
									<p><?php echo the_field('service_description_4',get_the_ID()); ?></p>
								</div>
							</div>
						</div>
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
									<img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-05.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_5',get_the_ID()); ?></h4>
									<p><?php echo the_field('service_description_5',get_the_ID()); ?></p>
								</div>
							</div>
						</div>
						<div class="col-lg-4 appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="400">
							<div class="feature-box feature-box-style-2">
								<div class="feature-box-icon">
									<img src="<?php echo get_template_directory_uri(); ?>/img/about-us/icons/icon-06.png" alt="User Icon" style="width: 24px; height: 24px;">
								</div>
								<div class="feature-box-info">
									<h4 class="font-weight-bold mb-2"><?php echo the_field('service_title_6',get_the_ID()); ?></h4>
									<p><?php echo the_field('service_description_6',get_the_ID()); ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>	
                
                <!-- stats section  -->

				<section class="section section-primary border-top-0 mb-0">
					<div class="container text-center">
						<div class="row counters counters-sm counters-text-light justify-content-center">
							<div class="col-lg-8">
								<?php echo the_field('cta_description',get_the_ID()); ?>
							</div>
						</div>
					</div>
				</section>
				
                <!-- reversed cards section  -->
				<div class="container-fluid container container-xl-custom abts" style="margin-top: 6em; margin-bottom: 6em;">
					<!-- Section 1 -->
					<div class="row align-items-center bg-color-grey">
						<div class="col-lg-6 p-0">
							<div class="parallax m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'parallaxHeight': '100%', 'parallaxScale': true}" data-image-src="<?php echo the_field('image_1',get_the_ID()); ?>" style="min-height: 315px;">
								</div>
							<!-- <section class="parallax section section-parallax border-top-0 h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5}" data-image-src="https://demoforclients.com/just-cremations-sydney/wp-content/uploads/2025/05/info-01.png" style="min-height: 100%;">
							</section> -->
						</div>
						<div class="col-lg-6 p-0">
							<div class="section section-no-border h-100 m-0">
								<div class="row m-0">
									<div class="col-half-section col-half-section-left">
										 <?php echo the_field('description_1',get_the_ID()); ?>
									</div>
								</div>
							</div>
						</div>
						
					</div>
					<!--<div class="row align-items-center bg-color-grey">
						<div class="col-lg-6 p-0">
							<div class="h-100 m-0" style="min-height: 415px; background: url('<?php echo the_field('image_1',get_the_ID()); ?>') center center / cover no-repeat;"></div>
						</div>
						<div class="col-lg-6 p-0">
							<div class="section section-no-border h-100 m-0">
								<div class="row m-0">
									<div class="col-half-section col-half-section-left">
										 <?php //echo the_field('description_1',get_the_ID()); ?>
									</div>
								</div>
							</div>
						</div>
					</div>-->
				
					<!-- Section 2 -->
<!-- Section 2 -->
					<div class="row align-items-center bg-color-grey">
						<div class="col-lg-6 p-0">
							<div class="section section-no-border h-100 m-0">
								<div class="row m-0">
									<div class="col-half-section col-half-section-left">
										 <?php echo the_field('description_2',get_the_ID()); ?>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-6 p-0">
							<div class="parallax m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'parallaxHeight': '100%', 'parallaxScale': true}" data-image-src="<?php echo the_field('image_2',get_the_ID()); ?>" style="min-height: 315px;">
								</div>
							<!-- <section class="parallax section section-parallax border-top-0 h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5}" data-image-src="https://demoforclients.com/just-cremations-sydney/wp-content/uploads/2025/05/info-01.png" style="min-height: 100%;">
							</section> -->
						</div>
						
						
					</div>
<!-- <div class="row align-items-center bg-color-grey">
    <div class="col-lg-6 order-2 order-lg-1 p-0">
        <div class="section section-no-border h-100 m-0">
            <div class="row justify-content-end m-0">
                <div class="col-half-section col-half-section-right text-start text-lg-end">
                   <?php //echo the_field('description_2',get_the_ID()); ?>
				</div>
            </div>
        </div>
    </div>
    <div class="col-lg-6 order-1 order-lg-2 p-0">
        <div class="h-100 m-0" style="min-height: 315px; background: url('<?php //echo the_field('image_2',get_the_ID()); ?>') center center / cover no-repeat;"></div>
    </div>
</div>-->

				
					<!-- Section 3 -->
					<div class="row align-items-center bg-color-grey">
						<div class="col-lg-6 p-0">
							<div class="parallax m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5, 'parallaxHeight': '100%', 'parallaxScale': true}" data-image-src="<?php echo the_field('image_3',get_the_ID()); ?>" style="min-height: 315px;">
								</div>
							<!-- <section class="parallax section section-parallax border-top-0 h-100 m-0" data-plugin-parallax data-plugin-options="{'speed': 1.5}" data-image-src="https://demoforclients.com/just-cremations-sydney/wp-content/uploads/2025/05/info-01.png" style="min-height: 100%;">
							</section> -->
						</div>
						<div class="col-lg-6 p-0">
							<div class="section section-no-border h-100 m-0">
								<div class="row m-0">
									<div class="col-half-section col-half-section-left">
										 <?php echo the_field('description_3',get_the_ID()); ?>
									</div>
								</div>
							</div>
						</div>
						
					</div>
					<!--<div class="row align-items-center bg-color-grey">
						<div class="col-lg-6 p-0">
							<div class="h-100 m-0" style="min-height: 315px; background: url('<?php echo the_field('image_3',get_the_ID()); ?>') center center / cover no-repeat;"></div>
						</div>
						<div class="col-lg-6 p-0">
							<div class="section section-no-border h-100 m-0">
								<div class="row m-0">
									<div class="col-half-section col-half-section-left">
										 <?php echo the_field('description_3',get_the_ID()); ?>
									</div>
								</div>
							</div>
						</div>
					</div> -->
				</div>
				 <section class="section section-height-3 custom-section-half-background-color-light custom-bg-color-grey-1 border-0 pb-0 m-0">
                    <div class="container container-xl-custom pb-5 " style="background-image: url(<?php echo get_template_directory_uri(); ?>/img/demos/it-services/puzzle.png); background-repeat: no-repeat; background-position: 50px 0;">
                    <div class="row pt-4 pb-lg-5 mb-0">
                        <div class="col-md-6 col-lg-4 mb-5 mb-md-0">
                            <h2 class="text-color-dark font-weight-bold text-6 line-height-2 pe-3 mb-4"><?php echo the_field('testimonial_title',7); ?></h2>
                            <p class="custom-text-size-1 mb-0"><?php echo the_field('testimonial_description',7); ?></p>  
                        </div>
                        <div class="col-md-6 col-lg-8">
                        	<div class="owl-carousel owl-theme" data-plugin-options="{'items': 1, 'autoplay': true, 'autoplayTimeout': 3000}">
								
								<div>
									<div class="testimonial testimonial-style-4 custom-testimonial-style-1 border-0 box-shadow-none mb-0">
		                                <blockquote>
		                                    <p class="custom-font-secondary font-weight-bold font-italic text-color-dark text-5 line-height-5 negative-ls-1 mb-2"><?php echo the_field('testimonial_description_1',7); ?></p>
		                                </blockquote>
		                                <div class="testimonial-author flex-column align-items-start mt-0">
		                                    <strong class="text-color-dark font-weight-semibold d-block line-height-1 mb-0"><?php echo the_field('client_name_1',7); ?></strong>
		                                   <!--  <span class="font-weight-semibold">CEO</span> -->
		                                </div>
		                            </div>
								</div>
								<div>
									<div class="testimonial testimonial-style-4 custom-testimonial-style-1 border-0 box-shadow-none mb-0">
		                                <blockquote>
		                                    <p class="custom-font-secondary font-weight-bold font-italic text-color-dark text-5 line-height-5 negative-ls-1 mb-2"><?php echo the_field('testimonial_description_2',7); ?></p>
		                                </blockquote>
		                                <div class="testimonial-author flex-column align-items-start mt-0">
		                                    <strong class="text-color-dark font-weight-semibold d-block line-height-1 mb-0"><?php echo the_field('client_name_2',7); ?></strong>
		                                    <!-- <span class="font-weight-semibold">CEO</span> -->
		                                </div>
		                            </div>
								</div>
								<div>
									<div class="testimonial testimonial-style-4 custom-testimonial-style-1 border-0 box-shadow-none mb-0">
		                                <blockquote>
		                                    <p class="custom-font-secondary font-weight-bold font-italic text-color-dark text-5 line-height-5 negative-ls-1 mb-2"><?php echo the_field('testimonial_description_3',7); ?></p>
		                                </blockquote>
		                                <div class="testimonial-author flex-column align-items-start mt-0">
		                                    <strong class="text-color-dark font-weight-semibold d-block line-height-1 mb-0"><?php echo the_field('client_name_3',7); ?></strong>
		                                    <!-- <span class="font-weight-semibold">CEO</span> -->
		                                </div>
		                            </div>
								</div>
								<div>
									<div class="testimonial testimonial-style-4 custom-testimonial-style-1 border-0 box-shadow-none mb-0">
		                                <blockquote>
		                                    <p class="custom-font-secondary font-weight-bold font-italic text-color-dark text-5 line-height-5 negative-ls-1 mb-2"><?php echo the_field('testimonial_description_4',7); ?></p>
		                                </blockquote>
		                                <div class="testimonial-author flex-column align-items-start mt-0">
		                                    <strong class="text-color-dark font-weight-semibold d-block line-height-1 mb-0"><?php echo the_field('client_name_4',7); ?></strong>
		                                    <!-- <span class="font-weight-semibold">CEO</span> -->
		                                </div>
		                            </div>
								</div>
							</div>
                            
                        </div>
                    </div>
                    
                </div>
                </section>

			</div>

            <!-- testimonials  -->
             
         

            <!-- footer border and footer  -->
			<div class="container container-xl-custom border-up-footer">
				<div class="row">
							<div class="col">
								<hr class="my-0">
							</div>
						</div>
			</div>
	
<?php
get_footer();
?>