<?php
/**
 * Template Name: Contact Us Page
 *
 * @package WordPress
 */
get_header(); 
if (has_post_thumbnail()){ 
$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large');
} 
?>
<style>
.custom-link-effect-1.btn:hover {
   color: #001e61 !important;
}
.btn-primary:focus:not(.bg-transparent), .btn-primary.focus:not(.bg-transparent) {
  background: none !important;
}
</style>
<div role="main" class="main">
<section class="page-header page-header-modern page-header-background page-header-background-md parallax overlay overlay-color-dark overlay-show overlay-op-5 mt-0" data-plugin-parallax data-plugin-options="{'speed': 1.2}" data-image-src="<?php echo $thumbnail[0];?>">
	<div class="container">
		<div class="row mt-5">
			<div class="col-md-12 align-self-center p-static order-2 text-center">
				 <?php while(have_posts() ) : the_post(); the_content(); endwhile; wp_reset_query();?>
			</div>
			<div class="col-md-12 align-self-center order-1">
				<ul class="breadcrumb breadcrumb-light d-block text-center">
					<li><a href="<?php echo home_url();?>">Home</a></li>
					<li class="active">Contact Us</li>
				</ul>
			</div>
		</div>
	</div>
</section>
                

				<div class="container-fluid container container-xl-custom">

					<div class="row py-4">
						<div class="col-lg-7 appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="650">

							
							<?php echo do_shortcode('[contact-form-7 id="bb0a67f" title="Contact Us Form"]');?>

						</div>
						<div class="col-lg-5">

                            <!-- our office  -->

							<div class="appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="800">
								<h4 class="text-primary pt-5">Our <strong>Office</strong></h4>
								<ul class="list list-icons list-icons-style-3 mt-2">
									<li><i class="fas fa-map-marker-alt top-6"></i> <strong>Address:</strong> <?php echo the_field('address',get_the_ID()); ?></li>
									<li><i class="fas fa-phone top-6"></i> <strong>Phone:</strong> <?php echo the_field('phone',get_the_ID()); ?></li>
									<li><i class="fas fa-envelope top-6"></i> <strong>Email:</strong> <a href="mailto:<?php echo the_field('email',get_the_ID()); ?>"><?php echo the_field('email',get_the_ID()); ?></a></li>
								</ul>

							
                                <!-- busines hours  -->

								<h4 class="text-primary pt-2">Business <strong>Hours</strong></h4>
								<ul class="list list-icons list-dark mt-2">
									<li><i class="far fa-clock top-6"></i><?php echo the_field('our_hours',get_the_ID()); ?></li>
								</ul>
							</div>

                            <!-- get in touch  -->

							<div class="overflow-hidden mb-1">
								<h4 class="text-primary mb-0 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="200">Get in <strong>Touch</strong></h4>
							</div>
							<div class="overflow-hidden mb-3">
								<p class="lead text-4 mb-0 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="400"><?php echo the_field('description',get_the_ID()); ?></p>
							</div>
							<!-- <div class="overflow-hidden">
								<p class="mb-0 appear-animation" data-appear-animation="maskUp" data-appear-animation-delay="600">.to Fell free to get in touch with our friendly team anytime.</p>
							</div> -->


						</div>

					</div>

				</div>

			</div>


            <div class="container container-xl-custom">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3306.56870731791!2d151.05725177571543!3d-34.02928007316566!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6b12c745e5fae117%3A0xf656fe6f3be049ca!2s691%20Old%20Princes%20Hwy%2C%20Sutherland%20NSW%202232%2C%20Australia!5e0!3m2!1sen!2sin!4v1744011673586!5m2!1sen!2sin" width="100%" height="420" style="border:1;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>

            <!-- footer border and footer  -->
			<div class="container container-xl-custom border-up-footer">
				<div class="row">
							<div class="col">
								<hr class="my-0">
							</div>
						</div>
			</div> 	
<?php
get_footer();
?>