<?php
/**
 * Template Name: Faq Page
 *
 * @package WordPress
 */
get_header(); 
?>
<div role="main" class="main">
                
				<section class="page-header page-header-modern page-header-background page-header-background-md parallax overlay overlay-color-dark overlay-show overlay-op-5 mt-0" data-plugin-parallax data-plugin-options="{'speed': 1.2}" data-image-src="<?php echo get_template_directory_uri(); ?>/img/banner/banner-faq.png">
					<div class="container">
						<div class="row mt-5">
							<div class="col-md-12 align-self-center p-static order-2 text-center">
								<?php while(have_posts() ) : the_post(); the_content(); endwhile; wp_reset_query();?>
							</div>
							<div class="col-md-12 align-self-center order-1">
								<ul class="breadcrumb breadcrumb-light d-block text-center">
									<li><a href="<?php echo home_url();?>">Home</a></li>
									<li class="active">FAQ</li>
								</ul>
							</div>
						</div>
					</div>
				</section>

				<div class="container-fluid container container-xl-custom py-4">
					<div class="row">
						<div class="col">
							<h2 class="font-weight-normal text-7 mb-2">Frequently Asked <strong class="font-weight-extra-bold">Questions</strong></h2>
							<p class="lead" ><b style="font-weight: 700;">Simple answers to help you feel confident and informed.</b> <br> 
							We know planning a cremation can feel overwhelming — especially during a difficult time. Here are answers to the questions we get most often from families choosing our online cremation service.</p>
				
							<hr class="solid my-5">
				
							<div class="toggle toggle-primary m-0" data-plugin-toggle>
							<?php 
							$argsFQ = array(
							'post_type' => 'our_faq',
							'order'=> 'DESC',
							'posts_per_page' =>10
							); 
							$loopFQ = new WP_Query($argsFQ);
							$fq=1;
							while($loopFQ->have_posts()) : $loopFQ->the_post();
							?> 
								<section class="toggle <?php if($fq==1){?>active<?php }?>">
									<a class="toggle-title"><?php the_title();?></a>
									<div class="toggle-content">
										<p><?php the_content();?></p>
									</div>
								</section>
				            <?php $fq++; endwhile; wp_reset_postdata(); ?>	
								
							
							</div>
						</div>
					</div>
				</div>

				</div>

		

            <!-- footer border and footer  -->
			<div class="container container-xl-custom border-up-footer">
				<div class="row">
							<div class="col">
								<hr class="my-0">
							</div>
						</div>
			</div>  
	
<?php
get_footer();
?>